<?php
$parent_pages = array();

if(is_singular('career')) {
    array_push($parent_pages, get_listing_page_id('career'));
} elseif(is_singular('service')) {
    array_push($parent_pages, get_listing_page_id('service'));
    $parent_pages = array_merge($parent_pages, get_post_ancestors(get_the_ID()));
} elseif(is_singular('sector')) {
    array_push($parent_pages, get_listing_page_id('sector'));
    $parent_pages = array_merge($parent_pages, get_post_ancestors(get_the_ID()));
} elseif(is_singular('project')) {
    array_push($parent_pages, get_listing_page_id('project'));
    $parent_pages = array_merge($parent_pages, get_post_ancestors(get_the_ID()));
} elseif(is_singular('post')) {
    array_push($parent_pages, get_option('page_for_posts'));
} else {
    $parent_pages = get_post_ancestors(get_the_ID());
}

?>

<section class="breadcrumbs">
    <div class="container">
        <ul class="list-unstyled breadcrumbs__list">
            <li class="breadcrumbs__item">
                <a href="/" class="breadcrumbs__link" title="Homepage">
                    <i class="fal fa-home"></i>
                </a>
            </li>

            <?php if ($parent_pages != null && !empty($parent_pages)) {
                foreach ($parent_pages as $page) {
                    $page_title = get_the_title($page); ?>
                    <li class="breadcrumbs__item">
                        <a href="<?php echo get_the_permalink($page); ?>"
                           class="breadcrumbs__link"
                           title="<?php echo $page_title; ?>">
                            <?php echo $page_title; ?>
                        </a>
                    </li>
                <?php }
            } ?>

            <li class="breadcrumbs__item">
                <span class="breadcrumbs__current">
                    <?php echo get_the_title(); ?>
                </span>
            </li>
        </ul>
    </div>
</section>