<?php

$masthead_subtitle = get_field('service_masthead_masthead_subtitle');
if($masthead_subtitle == '' && $post->post_parent) {
    $masthead_subtitle = get_the_title($post->post_parent);
}

render_masthead('service_masthead', array(
    'show_breadcrumb' => true,
    'show_overlay' => false,
    'masthead_subtitle' => $masthead_subtitle
));

$form_title = get_theme_mod('service_form_title');
$form_intro = get_theme_mod('service_form_intro');
$form_shortcode = get_theme_mod('service_form_shortcode');

// Related Services
$related_services = null;
if($post->post_parent != null) {

    $args = [
        'post_type' => 'service',
        'post_status' => 'publish',
        'posts_per_page' => -1,
        'orderby' => 'menu_order',
        'order' => 'ASC',
        'post_parent' => $post->post_parent,
        'exclude' => get_the_ID()
    ];

    $related_services = get_posts($args);
}

?>

<section class="service js-contact-form-wrapper">
    <div class="container">
        <div class="row medium-gutters">
            <div class="col-12 col-lg-7">
                <div class="page-content-wrapper">
                    <?php render_content_blocks('service_content'); ?>
                </div>
            </div>

            <div class="col-12 col-lg-5">
                <?php include(get_template_directory() . '/inc/partials/sidebar-form.php'); ?>
            </div>
        </div>
    </div>
</section>

<?php include(get_template_directory() . '/inc/blocks/contact-cta.php'); ?>

<?php if($related_services != null && !empty($related_services)) { ?>
    <section class="service__related">
        <div class="container">
            <h2 class="service__related__title">
                <?php echo 'Other ' . get_the_title($post->post_parent) . ' Services'; ?></h2>

            <div class="row">
                <?php foreach($related_services as $service) { ?>
                    <div class="col-12 col-sm-6 col-md-4 service__related__item">
                        <?php include(get_template_directory() . '/inc/partials/service-card.php'); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </section>
<?php } ?>