<?php

if (isset($form_shortcode) && $form_shortcode != '') {

    $email = get_theme_mod('contact_email');
    $telephone = get_theme_mod('contact_telephone');

    ?>

    <section class="sidebar-form <?php echo (is_singular('project') ? 'sidebar-form--project' : ''); ?>">
        <div class="sidebar-form__inner">
            <div class="sidebar-form__header">
                <div class="row justify-content-center">
                    <?php if ($telephone != '') { ?>
                        <div class="col-auto text-center">
                            <a href="tel:<?php echo $telephone; ?>"
                               class="contact-link sidebar-form__header__link">
                            <span class="contact-link__icon">
                                <i class="fas fa-phone"></i>
                            </span>
                                <?php echo $telephone; ?>
                            </a>
                        </div>
                    <?php } ?>

                    <?php if ($email != '') { ?>
                        <div class="col-auto text-center">
                            <a href="mailto:<?php echo $email; ?>"
                               class="contact-link sidebar-form__header__link">
                            <span class="contact-link__icon">
                                <i class="fas fa-envelope"></i>
                            </span>
                                <?php echo $email; ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
            </div>

            <div class="sidebar-form__body js-sidebar-form">
                <?php if (isset($form_title) && $form_title != '') { ?>
                    <h2 class="small-title small-title--accented"><?php echo $form_title; ?></h2>
                <?php } ?>

                <?php if (isset($form_intro) && $form_intro != '') { ?>
                    <div class="sidebar-form__body__intro text-block">
                        <?php echo '<p>' . $form_intro . '</p>'; ?>
                    </div>
                <?php } ?>

                <div class="sidebar-form__body__form">
                    <?php echo do_shortcode($form_shortcode); ?>
                </div>
            </div>
        </div>
    </section>
<?php } ?>