<?php

get_header();

$masthead_subtitle = get_field('career_masthead_masthead_subtitle');
if($masthead_subtitle == '') {
    $masthead_subtitle = 'Job Opportunity';
}

render_masthead('career_masthead', array(
    'show_breadcrumb' => true,
    'show_overlay' => false,
    'masthead_subtitle' => $masthead_subtitle
));


$form_title = get_theme_mod('career_form_title');
$form_intro = get_theme_mod('career_form_intro');
$form_shortcode = get_theme_mod('career_form_shortcode');

?>

<section class="career js-contact-form-wrapper">
    <div class="container">
        <div class="row medium-gutters">
            <div class="col-12 col-lg-7">
                <div class="page-content-wrapper">
                    <?php render_content_blocks('career_content'); ?>
                </div>
            </div>

            <div class="col-12 col-lg-5">
                <?php include(get_template_directory() . '/inc/partials/sidebar-form.php'); ?>
            </div>
        </div>
    </div>
</section>

<?php

include(get_template_directory() . '/inc/blocks/contact-cta.php');
include(get_template_directory() . '/inc/blocks/featured-footer.php');

get_footer();