<?php

/* Template Name: Career Listing */

get_header();

render_masthead('career_listing_masthead', array(
    'show_breadcrumb' => true,
    'show_overlay' => false
));

// Form
$form_title = get_field('form_title');
$form_intro = get_field('form_introduction');
$form = get_field('form');
if ($form != null) {
    $form_shortcode = '[contact-form-7 id="' . $form->ID . '"]';
}

?>

    <section class="career-listing-template js-contact-form-wrapper">
        <div class="container">
            <div class="row medium-gutters">
                <div class="col-12 col-lg-7">
                    <div class="page-content-wrapper">
                        <?php render_content_blocks('career_listing_content'); ?>
                        <?php include(get_template_directory() . '/inc/blocks/career-listing.php'); ?>
                    </div>
                </div>

                <div class="col-12 col-lg-5">
                    <?php include(get_template_directory() . '/inc/partials/sidebar-form.php'); ?>
                </div>
            </div>
        </div>
    </section>
<?php

include(get_template_directory() . '/inc/blocks/contact-cta.php');
include(get_template_directory() . '/inc/blocks/featured-footer.php');

get_footer();