<?php

/* Template Name: Sector Listing */

get_header();

render_masthead('sector_listing_masthead');

$args = [
    'post_type' => 'sector',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'orderby' => 'menu_order',
    'order' => 'ASC'
];

$posts_query = new WP_Query($args);

?>

    <section class="service-listing">
        <?php include(get_template_directory() . '/inc/partials/breadcrumb.php'); ?>
        <div class="service-listing__grid">
            <div class="container">
                <div class="row">
                    <?php if ($posts_query->have_posts()) {
                        while ($posts_query->have_posts()) : $posts_query->the_post();
                            $service = $post; ?>
                            <div class="col-12 col-sm-6 col-md-4 service-listing__item">
                                <?php include(get_template_directory() . '/inc/partials/service-card.php'); ?>
                            </div>
                            <?php unset($service);
                        endwhile;
                    } else { ?>
                        <div class="col-12">
                            <h3>No services to show</h3>
                        </div>
                    <?php } ?>
                </div>
            </div>
    </section>

<?php

include(get_template_directory() . '/inc/blocks/featured-footer.php');

get_footer();
