<?php

$args = array(
    'numberposts' => -1,
    'orderby' => 'menu_order',
    'order' => 'ASC',
    'post_type' => 'team_member',
    'post_status' => 'publish'
);

$team_members = get_posts($args);

/* Template Name: Team */

get_header();

render_masthead('team_masthead');

?>

    <section class="team-members">
        <?php include(get_template_directory() . '/inc/partials/breadcrumb.php'); ?>

        <?php if ($team_members != null && !empty($team_members)) { ?>
            <section class="team-members__grid">
                <div class="container">
                    <div class="row">
                        <?php foreach ($team_members as $member) {
                            $thumb = get_the_post_thumbnail_url($member->ID, 'team-member');
                            $role = get_field('job_role', $member->ID);
                            $excerpt = get_the_excerpt($member->ID);
                            ?>
                            <div class="col-12 col-sm-6 col-lg-4 team-members__item">
                                <div class="team-member">
                                    <div class="team-member__image"
                                         style="background-image: url(<?php echo($thumb != '' ? $thumb : ''); ?>);"></div>

                                    <div class="team-member__content">
                                        <h3 class="m-0"><?php echo $member->post_title; ?></h3>

                                        <?php if($role != '') { ?>
                                            <p class="small-title team-member__role"><?php echo $role; ?></p>
                                        <?php } ?>

                                        <?php if($excerpt != '') { ?>
                                            <div class="text-block team-member__excerpt">
                                                <?php echo $excerpt; ?>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </section>
        <?php } ?>
    </section>

<?php

include(get_template_directory() . '/inc/blocks/career-listing.php');
include(get_template_directory() . '/inc/blocks/contact-cta.php');
include(get_template_directory() . '/inc/blocks/featured-footer.php');

get_footer();